function varargout = Tension(varargin)
% TENSION MATLAB code for Tension.fig
%      TENSION, by itself, creates a new TENSION or raises the existing
%      singleton*.
%
%      H = TENSION returns the handle to a new TENSION or the handle to
%      the existing singleton*.
%
%      TENSION('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in TENSION.M with the given input arguments.
%
%      TENSION('Property','Value',...) creates a new TENSION or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Tension_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Tension_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Tension

% Last Modified by GUIDE v2.5 24-Mar-2014 10:17:07

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Tension_OpeningFcn, ...
                   'gui_OutputFcn',  @Tension_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Tension is made visible.
function Tension_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Tension (see VARARGIN)

% Choose default command line output for Tension
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Tension wait for user response (see UIRESUME)
% uiwait(handles.figure1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% load image into Problem_Image
pic = imread('Tension.jpg','jpg');
axes(handles.Problem_Image);
imshow(pic);

% set up initial state of GUI
set(handles.warning_weight,'visible','off');
set(handles.warning_ang1,'visible','off');
set(handles.warning_ang2,'visible','off');
set(handles.edit_weight,'string','');
set(handles.edit_ang1,'string','');
set(handles.edit_ang2,'string','');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --- Outputs from this function are returned to the command line.
function varargout = Tension_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function edit_weight_Callback(hObject, eventdata, handles)
% hObject    handle to edit_weight (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_weight as text
%        str2double(get(hObject,'String')) returns contents of edit_weight as a double


% --- Executes during object creation, after setting all properties.
function edit_weight_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_weight (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_ang1_Callback(hObject, eventdata, handles)
% hObject    handle to edit_ang1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_ang1 as text
%        str2double(get(hObject,'String')) returns contents of edit_ang1 as a double


% --- Executes during object creation, after setting all properties.
function edit_ang1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_ang1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_ang2_Callback(hObject, eventdata, handles)
% hObject    handle to edit_ang2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_ang2 as text
%        str2double(get(hObject,'String')) returns contents of edit_ang2 as a double


% --- Executes during object creation, after setting all properties.
function edit_ang2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_ang2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in button_determine.
function button_determine_Callback(hObject, eventdata, handles)
% hObject    handle to button_determine (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% hide warnings
set(handles.warning_weight,'visible','off');
set(handles.warning_ang1,'visible','off');
set(handles.warning_ang2,'visible','off');

% get values from GUI
W = str2double(get(handles.edit_weight,'string'));
ang1 = str2double(get(handles.edit_ang1,'string'));
ang2 = str2double(get(handles.edit_ang2,'string'));

% check for missing values
if isnan(W)
    set(handles.warning_weight,'visible','on');
elseif isnan(ang1)
    set(handles.warning_ang1,'visible','on');
elseif isnan(ang2)
    set(handles.warning_ang2,'visible','on');
else
    % check for error with input arguments
    if W < 0
        error('You cannot have a negative weight.');
    elseif ang1 < 0 || ang1 > 90 || ang2 < 0 || ang2 > 90
        error('You cannot have an angle smaller than 0 or larger than 90.');
    end

    % compute tensions
    A = [-sind(ang1) sind(ang2); cosd(ang1) cosd(ang2)];
    b = [0;W];
    x = A\b;
    tension1 = x(1);
    tension2 = x(2);
   
    % display tensions
    set(handles.text_tension1,'string',tension1);
    set(handles.text_tension2,'string',tension2);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
